VERSION 5.00
Begin {C62A69F0-16DC-11CE-9E98-00AA00574A4F} NudgeTextForm 
   Caption         =   "UserForm1"
   ClientHeight    =   1800
   ClientLeft      =   45
   ClientTop       =   330
   ClientWidth     =   3735
   OleObjectBlob   =   "NudgeTextForm.frx":0000
   ShowModal       =   0   'False
   StartUpPosition =   1  'CenterOwner
End
Attribute VB_Name = "NudgeTextForm"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False

'   This is a part of the source code for Pro/DESKTOP.
'   Copyright (C) 1999 Parametric Technology Corporation.
'   All rights reserved.

'   File : CreateTableFromDims.bas

'   This tool provides a mechanism to move selected notecallouts by a step distance.
'   This tool can also be used for just nudging the text into place.
'   The tool uses a modeless dialog and users can work freely while the dialog is present.
'   The dialog activates/deactivates itself when the form gets a MouseMove event.


Option Explicit

Private app As ProDESKTOP

Private doc As DrawingDocument
Private drg As aDrawing

Private obSetCls As ObjectSetClass
Private itCls As ItClass
Private vectorCls As VectorClass

Private selection As ObjectSet

Private Type note
    text As aCalloutGroup
    pos As zVector
End Type

Private stepVector As zVector
Private stepVal As Double

Private noteArray() As note
Private resetPositionsArray() As zVector

Private activeDoc As Boolean

Private Sub cmdCancel_Click()

    ResetNotePositions
    Me.Hide
    Unload Me
    
End Sub

Private Sub cmdOK_Click()

    Me.Hide
    Unload Me
    
End Sub

Private Sub cmdReset_Click()

    ResetNotePositions
    
End Sub

Private Sub spnHorizontal_SpinDown()
    
    On Error GoTo BadValue
    stepVal = -CDbl(txtStep.text) / 1000
    On Error GoTo 0
    
    Set stepVector = vectorCls.CreateVector(stepVal, 0#, 0#)
    
    MoveNote
    
    Exit Sub

BadValue:
    Beep
    txtStep.SetFocus
    SendKeys "+{HOME}"
    
End Sub

Private Sub spnHorizontal_SpinUp()

    On Error GoTo BadValue
    stepVal = CDbl(txtStep.text) / 1000
    On Error GoTo 0
    
    Set stepVector = vectorCls.CreateVector(stepVal, 0#, 0#)
    
    MoveNote
    
    Exit Sub

BadValue:
    Beep
    txtStep.SetFocus
    SendKeys "+{HOME}"
    
End Sub

Private Sub spnVertical_SpinDown()

    On Error GoTo BadValue
    stepVal = -CDbl(txtStep.text) / 1000
    On Error GoTo 0
    
    Set stepVector = vectorCls.CreateVector(0#, stepVal, 0#)
    
    MoveNote
    
    Exit Sub

BadValue:
    Beep
    txtStep.SetFocus
    SendKeys "+{HOME}"
    
End Sub

Private Sub spnVertical_SpinUp()

    On Error GoTo BadValue
    stepVal = CDbl(txtStep.text) / 1000
    On Error GoTo 0
    
    Set stepVector = vectorCls.CreateVector(0#, stepVal, 0#)
    
    MoveNote
    
    Exit Sub

BadValue:
    Beep
    txtStep.SetFocus
    SendKeys "+{HOME}"
    
End Sub

Private Sub UserForm_Activate()
    
    Set app = CreateObject("ProDESKTOP.Application")
    app.SetVisible True
    
    On Error GoTo noDoc
    Set doc = app.GetActiveDoc
    Set drg = doc.GetDrawing
    On Error GoTo 0
    
    Set obSetCls = app.GetClass("ObjectSet")
    Set itCls = app.GetClass("it")
    Set vectorCls = app.GetClass("Vector")
    
    If GetNotesCheck Then
        Me.spnVertical.Enabled = True
        Me.spnHorizontal.Enabled = True
        CreateNoteArray
    Else
        Me.spnVertical.Enabled = False
        Me.spnHorizontal.Enabled = False
    End If
    
    Exit Sub
    
noDoc:
    MsgBox "No open drawing"
    Unload Me
End Sub

Private Sub UserForm_Initialize()

    txtStep.text = 1
    Me.Caption = "Move Text"
    cmdOK.Caption = "OK"
    cmdCancel.Caption = "Cancel"
    cmdReset.Caption = "Reset"
    
End Sub


Private Function GetNotesCheck() As Boolean

    GetNotesCheck = False
    
    Set selection = obSetCls.CreateAObjectSet()
    Set selection = doc.GetSelection("NoteCallout")
    If selection.GetCount = 0 Then
        GetNotesCheck = False
    Else
        GetNotesCheck = True
    End If
    
End Function


Private Sub CreateNoteArray()

    ReDim noteArray(selection.GetCount)
    ReDim resetPositionsArray(selection.GetCount)
    
    Dim api As helm
    Set api = app.TakeHelm
    
    
    Dim it As iterator, i As Integer
    i = 0
    Set it = itCls.CreateAObjectIt(selection)
    it.start
    
    Dim currentNote As aCalloutGroup, noteC As aNoteCallout
    Do While it.IsActive
        Set noteC = it.Current
        Set currentNote = noteC.GetParent("CalloutGroup")
        Set noteArray(i).text = currentNote
        Set noteArray(i).pos = currentNote.GetControlPoint(topCenter)
        it.Next
        i = i + 1
    Loop
    
    For i = 0 To UBound(resetPositionsArray)
        Set resetPositionsArray(i) = noteArray(i).pos
    Next
    
    app.ReleaseHelm api
    
End Sub

Private Sub MoveNote()

    Dim i As Integer
    Dim pos As zVector
    Dim api As helm
    Set api = app.TakeHelm
    i = 0
    For i = 0 To UBound(noteArray) - 1
        Set pos = noteArray(i).text.GetControlPoint(topCenter)
        Set pos = pos.Add(stepVector)
        noteArray(i).text.SetControlPoint topCenter, pos
    Next
    api.CommitCalls "Move Text", False
    app.ReleaseHelm api
    
End Sub

Private Sub ResetNotePositions()

    Dim i As Integer
    Dim pos As zVector
    Dim currentPos As zVector
    Dim x1 As Double, x2 As Double
    Dim y1 As Double, y2 As Double
    Dim nl As String
    nl = Chr(10) & Chr(13)
    
    Dim api As helm
    Set api = app.TakeHelm
    If Not selection.GetCount = 0 Then
        i = 0
        For i = 0 To UBound(resetPositionsArray) - 1
            Set pos = resetPositionsArray(i)
            noteArray(i).text.SetControlPoint topCenter, pos
        Next
    End If
    api.CommitCalls "Move Text", False
    app.ReleaseHelm api
    
End Sub

Private Sub UserForm_MouseMove(ByVal Button As Integer, ByVal Shift As Integer, ByVal x As Single, ByVal Y As Single)

    If GetNotesCheck Then
        Me.spnVertical.Enabled = True
        Me.spnHorizontal.Enabled = True
        'CreateNoteArray
    Else
        Me.spnVertical.Enabled = False
        Me.spnHorizontal.Enabled = False
    End If
    
End Sub
